﻿using System;

namespace BoFilTest.Domain.Modules
{
    public class ModbusUtilities
    {
        public static uint DecodeDWord(ushort[] input)
        {
            var bytes = ToBytes(input);
            return BitConverter.ToUInt32(bytes, 0);

        }

        private static byte[] ToBytes(ushort[] input)
        {
            var a = BitConverter.GetBytes(input[1]);
            var b = BitConverter.GetBytes(input[0]);

            byte[] f = new byte[4];
            Buffer.BlockCopy(a, 0, f, 0, 2);
            Buffer.BlockCopy(b, 0, f, 2, 2);
            return f;
        }

        public static float DecodeFloat(ushort[] input)
        {
            byte[] bytes = ToBytes(input);
            return BitConverter.ToSingle(bytes, 0);
        }

        public static ushort[] EncodeFloat(float value)
        {
            var bytes = BitConverter.GetBytes(value);
            ushort[] result = new ushort[2];
            Buffer.BlockCopy(bytes, 0, result, 2, 2);
            Buffer.BlockCopy(bytes, 2, result, 0, 2);
            return result;
        }
    }
}
