﻿using BoFilTest.Utils;
using Optional;
using System;

namespace BoFilTest.Domain.Modules.Balance
{
    class EmulatedBalance : IBalance
    {
        private readonly SecondTimer Timer;

        public EmulatedBalance()
        {
            this.Timer = new SecondTimer();
        }

        public void Cleanup()
        {
            // Nothing to do
        }

        public Option<Gram> ReadValue()
        {
            double value = -Math.Cos(Timer.Get() / 20.0 * 2.0 * Math.PI);
            return Option.Some(Gram.From(value));
        }
    }
}
