﻿
using BoFilTest.Utils;
using Optional.Collections;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Controls;

namespace BoFilTest.Domain
{

    public class ComboData
    {
        public object Id { get; set; }
        public string Value { get; set; }
    }

    public class EnumItems<EnumType> : IEnumerable<ComboData>
    {
        private readonly List<ComboData> list;

        public EnumItems()
        {
            this.list = new List<ComboData>();
        }

        public string NameFor(EnumType value)
        {
            return this.list.Where(x => value.Equals(x.Id)).FirstOrNone().Map(x => x.Value).ValueOr("");
        }

        public void Add(EnumType value, TranslationKey text)
        {
            this.list.Add(new ComboData { Id = value, Value = Translated.FromKey(text) });

        }
        public IEnumerator<ComboData> GetEnumerator()
        {
            return this.list.GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.list.GetEnumerator();
        }

        public void BindTo(ComboBox comboBox)
        {
            comboBox.ItemsSource = this;
            comboBox.DisplayMemberPath = "Value";
            comboBox.SelectedValuePath = "Id";
        }
    }

    public enum FilterCakeConsistency
    {
        NotSelected,
        Dry,
        Leathery,
        Moist,
        Muddy,
    }

    public enum FilterCakeCracking
    {
        NotSelected,
        Without,
        Slight,
        Medium,
        Strong,
    }

    public enum EdgeDissolution
    {
        NotSelected,
        Yes,
        No,
    }

    public class CakeProperties
    {
        public static EnumItems<FilterCakeConsistency> FilterCakeConsistencyNames = new EnumItems<FilterCakeConsistency>
        {
            {FilterCakeConsistency.NotSelected, new TranslationKey("PULL_DOWN_NOT_SELECTED") },
            {FilterCakeConsistency.Dry, new TranslationKey("FILTER_CAKE_DRY") },
            {FilterCakeConsistency.Leathery, new TranslationKey("FILTER_CAKE_LEATHERY") },
            {FilterCakeConsistency.Moist, new TranslationKey("FILTER_CAKE_MOIST") },
            {FilterCakeConsistency.Muddy, new TranslationKey("FILTER_CAKE_MUDDY") }
        };

        public static EnumItems<FilterCakeCracking> FilterCakeCrackingNames = new EnumItems<FilterCakeCracking>
        {
            {FilterCakeCracking.NotSelected, new TranslationKey("PULL_DOWN_NOT_SELECTED") },
            {FilterCakeCracking.Without, new TranslationKey("CRACK_WITHOUT") },
            {FilterCakeCracking.Slight, new TranslationKey("CRACK_SLIGHT") },
            {FilterCakeCracking.Medium, new TranslationKey("CRACK_MEDIUM") },
            {FilterCakeCracking.Strong, new TranslationKey("CRACK_STRONG") },
        };

        public static EnumItems<EdgeDissolution> EdgeDissolutionNames = new EnumItems<EdgeDissolution>
        {
            {EdgeDissolution.NotSelected, new TranslationKey("PULL_DOWN_NOT_SELECTED") },
            {EdgeDissolution.Yes, new TranslationKey("EDGE_DISSOLUTION_YES") },
            {EdgeDissolution.No, new TranslationKey("EDGE_DISSOLUTION_NO") },
        };
    }
}
