﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace BoFilTest.YoctoDemo
{
    class Program
    {
        static void Main(string[] args)
        {
            string Message = "";
            if (YAPI.RegisterHub("usb", ref Message) != YAPI.SUCCESS)
            {
                Console.WriteLine("Unable to initialize Yocto API");
                return;
            }
            string errmsg = "";
            if (YAPI.UpdateDeviceList(ref errmsg) != YAPI.SUCCESS)
            {
                Console.WriteLine("Unable to get device list.");
                return;
            }

            YSensor sensor = YSensor.FindSensor("RX420MA1-C6514.genericSensor1");

            //YSensor sensor = YSensor.FirstSensor();

            if (sensor == null)
            {
                Console.WriteLine("Did not find pressure sensor");
                return;
            }

            //while (sensor != null)
            //{
            //    Console.WriteLine(sensor.describe());
            //    sensor = sensor.nextSensor();
            //}

            for (int i = 0; i < 100; ++i)
            {
                //YAPI.HandleEvents(ref errmsg);
                if (sensor.isOnline())
                {
                    Console.WriteLine("Current value {0}", sensor.get_currentValue());
                }
                else
                {
                    Console.WriteLine("Sensor offline!");
                }

                Thread.Sleep(1000);
            }

            Console.WriteLine("Shutdown");
            YAPI.UnregisterHub("usb");
        }
    }
}
