﻿using BoFilTest.Domain.Modules;
using NUnit.Framework;

namespace BoFilTest.Tests
{
    [TestFixture]
    public class ModbusUtilitiesTest
    {
        [Test]
        public void CanDecodeFloatFromTwoWords()
        {
            var words = new ushort[] { 0x4229, 0xae14 };
            var decoded = ModbusUtilities.DecodeFloat(words);
            Assert.AreEqual(decoded, 42.42f);
        }

        [Test]
        public void CanEncodeFloatToTwoWords()
        {
            var encoded = ModbusUtilities.EncodeFloat(42.42f);
            Assert.AreEqual(new ushort[] { 0x4229, 0xae14 }, encoded);
        }
    }
}
