﻿using NUnit.Framework;
using BoFilTest.Utils;
using System.Threading;

namespace BoFilTest.Tests
{
    [TestFixture]
    public class FormatTests
    {

        [Test]
        public void GasIntegralForAreaTruncatesToTwoDecimals()
        {
            // BOF-62
            var separator = Thread.CurrentThread.CurrentCulture.NumberFormat.NumberDecimalSeparator;
            Assert.AreEqual("5" + separator + "43", Format.GasIntegralForArea(5.4321));
        }

        [Test]
        public void GasIntegralForAreaExpandsToTwoDecimals()
        {
            // BOF-62
            var separator = Thread.CurrentThread.CurrentCulture.NumberFormat.NumberDecimalSeparator;
            Assert.AreEqual("7" + separator + "00", Format.GasIntegralForArea(7.0));
        }
    }
}
