﻿using BoFilTest.Domain;
using BoFilTest.Utils;
using IniParser.Model;
using NUnit.Framework;
using System;

namespace BoFilTest.Tests
{
    [TestFixture]
    public class FormTests
    {
        public IPersistencyMapping LoaderFor(DefaultsConfiguration config)
        {
            return new FormLoader(config);
        }

        [Test]
        public void ProjectNumberIsEmptyByDefault()
        {
            var form = new Form();
            Assert.AreEqual("", form.ProjectNumber);
        }

        [Test]
        public void CanLoadProjectNumber()
        {
            var form = MappedForm();
            Assert.AreEqual("ABC45698", form.ProjectNumber);            
        }

        [Test]
        public void CanLoadWashingAmount()
        {
            var form = MappedForm();
            Assert.AreEqual(0.5, form.WashingPassFluidAmount[0]);
        }

        [Test]
        public void CanLoadDemoisturizingTime()
        {
            var form = MappedForm();
            Assert.AreEqual(TimeSpan.FromSeconds(7.0), form.IntermediateDemoisturizationTime);
        }

        [Test]
        public void CanLoadGasBreakthrough()
        {
            var form = MappedForm();
            Assert.AreEqual(true, form.UseGasBreakthrough);
        }

        private Form MappedForm()
        {
            var form = new Form();
            form.ApplyMapping(LoaderFor(SampleDefaults()));
            return form;
        }

        private DefaultsConfiguration SampleDefaults()
        {
            return new Configuration(new IniParser.Parser.IniDataParser().Parse(IniFileContents)).Defaults();
        }

        static readonly string IniFileContents = @"
[Defaults]
project.number=ABC45698
purchase.order.number=
client=
test.operator=
lab.equipment=
acquisition.interval=0.5
product=
product.number=
solid.density=1500
liquid.density=1000
dyn.viscosity=1
suspension.concentration=25
suspension.temperature=20
flocculant.type=-
flocculant.concentration=0
flocculant.amount=0
washing.medium=-
washing.fluid.temperature=20
washing.enabled=no
washing.count=1
washing.amount.1=0.5
washing.amount.2=0.25
washing.amount.3=0
intermediate.demoisturizing.time=7
gas.temperature=21
filter.cloth=
filter.area=19.63
filtration.pressure.difference=1
demoisturization.ratio=1.5
press.enabled=no
press.pressure=0
press.time=0
vaporization.enabled=no
vaporization.time=0
use.gas.breakthrough=yes";
    }
}
