﻿using BoFilTest.Domain;
using BoFilTest.Utils;
using System;
using System.ComponentModel;

namespace BoFilTest.UI
{
    public class StartModel : INotifyPropertyChanged
    {
        private readonly Form form;
        private readonly DataModel dataModel;

        public StartModel(DataModel dataModel)
        {
            this.form = dataModel.Form;
            this.dataModel = dataModel;
        }

        public string Title => Translated.FromKey("TEST_ID_TITLE", dataModel.TestNumber);

        public string DateTime => string.Format("{0} {1}", form.Date.ToLongDateString(), form.Date.ToString("HH:mm"));

        public string ProjectNumber
        {
            get
            {
                return this.form.ProjectNumber;
            }
            set
            {
                this.form.ProjectNumber = value;
            }
        }

        public string PurchaseOrderNumber
        {
            get
            {
                return this.form.PurchaseOrderNumber;
            }
            set
            {
                this.form.PurchaseOrderNumber = value;
            }
        }

        public string Client
        {
            get
            {
                return this.form.Client;
            }
            set
            {
                this.form.Client = value;
            }
        }

        public string TestOperator
        {
            get { return form.TestOperator; }
            set { form.TestOperator = value; }
        }

        public string LabEquipment
        {
            get { return form.LabEquipment; }
            set { form.LabEquipment = value; }
        }

        public double AcquisitionInterval
        {
            get { return form.AcquisitionInterval.TotalSeconds; }
            set { form.AcquisitionInterval = TimeSpan.FromSeconds(value); }
        }

        public string Product
        {
            get { return form.Product; }
            set { form.Product = value; }
        }

        public string ProductNumber
        {
            get { return form.ProductNumber; }
            set { form.ProductNumber = value; }
        }

        public double SuspensionConcentration
        {
            get { return form.SuspensionConcentration; }
            set { form.SuspensionConcentration = value; }
        }

        public double SuspensionTemperature
        {
            get { return form.SuspensionTemperature; }
            set { form.SuspensionTemperature = value; }
        }

        public double SolidDensity
        {
            get { return form.SolidDensity;  }
            set { form.SolidDensity = value; }
        }

        public double LiquidDensity
        {
            get { return form.LiquidDensity; }
            set { form.LiquidDensity = value; }
        }

        public double DynamicViscosity
        {
            get { return form.DynamicViscosity; }
            set { form.DynamicViscosity = value; }
        }

        public string CoagulantType
        {
            get { return form.FlocculantType; }
            set { form.FlocculantType = value; }
        }

        public double CoagulantConcentration
        {
            get { return form.FlocculantConcentration; }
            set { form.FlocculantConcentration = value; }
        }

        public double CoagulantAmount
        {
            get { return form.FlocculantAmount; }
            set { form.FlocculantAmount = value; }
        }

        public string WashingMedium
        {
            get { return form.WashingMedium; }
            set { form.WashingMedium = value; }
        }

        public double WashingFluidTemperature
        {
            get { return form.WashingFluidTemperature; }
            set { form.WashingFluidTemperature = value; }
        }

        public double GasTemperature
        {
            get { return form.GasTemperature; }
            set { form.GasTemperature = value; }
        }

        public string FilterCloth
        {
            get { return form.FilterCloth; }
            set { form.FilterCloth = value; }
        }

        public double FilterArea
        {
            get { return form.FilterArea; }
            set { form.FilterArea = value; }
        }

        public double FilterPressureDifference
        {
            get { return form.FilterPressureDifference; }
            set { form.FilterPressureDifference = value; }
        }

        public double DemoisturizationQuotient
        {
            get { return form.DemoisturizationRatio; }
            set { form.DemoisturizationRatio = value; }
        }

        public bool WashingEnabled
        {
            get { return form.WashingEnabled; }
            set { form.WashingEnabled = value; }
        }

        public int WashingPassCount
        {
            get { return form.WashingPassCount; }
            set { form.WashingPassCount = Math.Max(1, Math.Min(3, value)); }
        }

        public double WashingPass0FluidAmount
        {
            get { return form.WashingPassFluidAmount[0]; }
            set { form.WashingPassFluidAmount[0] = value; }
        }

        public double WashingPass1FluidAmount
        {
            get { return form.WashingPassFluidAmount[1]; }
            set { form.WashingPassFluidAmount[1] = value; }
        }

        public double WashingPass2FluidAmount
        {
            get { return form.WashingPassFluidAmount[2]; }
            set { form.WashingPassFluidAmount[2] = value; }
        }

        public double IntermediateDemoisturizationTime
        {
            get { return form.IntermediateDemoisturizationTime.TotalSeconds; }
            set { form.IntermediateDemoisturizationTime = TimeSpan.FromSeconds(value); }
        }

        public bool PressingEnabled
        {
            get { return form.PressEnabled; }
            set { form.PressEnabled = value; }
        }

        public double PressingTime
        {
            get { return form.PressTime.TotalSeconds; }
            set { form.PressTime = TimeSpan.FromSeconds(value); }
        }

        public double PressingPressure
        {
            get { return form.PressPressure; }
            set { form.PressPressure = value; }
        }

        public bool VaporizationEnabled
        {
            get { return form.VaporizationEnabled; }
            set { form.VaporizationEnabled = value; }
        }

        public double VaporizationTime
        {
            get { return form.VaporizationTime.TotalSeconds; }
            set { form.VaporizationTime = TimeSpan.FromSeconds(value); }
        }

        public bool UseGasBreakthrough
        {
            get { return form.UseGasBreakthrough; }
            set { form.UseGasBreakthrough = value; }
        }

        public void RefreshAll()
        {
            SendPropertyChanged("");
        }

        #region INotifyPropertyChanged Members

        public event PropertyChangedEventHandler PropertyChanged;

        private void SendPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }
        #endregion
    }
}
