﻿using BoFilTest.Domain;
using BoFilTest.Utils;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace BoFilTest.UI
{
    class Beeper
    {
        public Beeper(EventBus eventBus)
        {
            eventBus.Subscribe<TimeoutHit>(message =>
            {
                this.LongBeep();
            });

            eventBus.Subscribe<StepChanged>(message =>
            {
                this.ShortBeep();
            });

            eventBus.Subscribe<TestFinished>(message =>
            {
                this.ShortBeep();
            });
        }

        void ShortBeep()
        {
            Task.Run(() => Console.Beep(800, 500));
        }

        void LongBeep()
        {
            Task.Run(() => Console.Beep(800, 1500));
        }
    }
}
