﻿using System;

namespace BoFilTest.Domain
{
    public class TestStep
    {
        // Create a step with a count-down
        public TestStep(StepDescription description, Func<TestTimings, TimeSpan> countDown, Action<TestTimings, TimeSpan> done)
            : this(description, done)
        {
            this.CountDown = countDown;
            this.HasCountDown = true;
        }

        // Create a step with a count-up.
        public TestStep(StepDescription description, Action<TestTimings, TimeSpan> done)
        {
            this.Description = description;
            this.Done = done;
            this.HasCountDown = false;
        }

        public TimeSpan EvaluateCountDown(TestTimings timings)
        {
            return CountDown(timings);
        }

        public StepDescription Description { get; }
        public int Index { get; }
        public bool RecordValues => Description.IsRecording;
        public Action<TestTimings, TimeSpan> Done { get; }
        private Func<TestTimings, TimeSpan> CountDown { get; }
        public bool HasCountDown
        {
            get;
        }
    }
}
