﻿using BoFilTest.Utils;
using NLog;

namespace BoFilTest.Domain
{
    class TestLogging
    {
        public static Logger Logger
        {
            get
            {
                return LogManager.GetCurrentClassLogger();
            }
        }

        public static void Setup(EventBus bus)
        {
            bus.Subscribe<TestStarted>(message =>
            {
                Logger.Info("Test started...");
            });

            bus.Subscribe<NewValues>(message =>
            {
            });

            bus.Subscribe<TestFinished>(message =>
            {
                Logger.Info("Test finished...");
            });

            bus.Subscribe<StepChanged>(message =>
            {
                Logger.Info("Test step changed...");
            });
        }
    }
}
