﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Optional;

namespace BoFilTest.Domain.Modules
{
    class YoctupuceExtraMeasure : IExtraMeasure
    {
        private static NLog.Logger logger = NLog.LogManager.GetCurrentClassLogger();
        private readonly YSensor sensor;

        public YoctupuceExtraMeasure(string DeviceName)
        {
            logger.Info("Starting Yoctopuce pressure measure with device name {0}", DeviceName);

            YoctupuceCapability.Acquire();

            this.sensor = YSensor.FindSensor(DeviceName);
            if (this.sensor == null)
            {
                throw new HardwareException("Did not find sensor: " + DeviceName);
            }
        }

        public void Cleanup()
        {
            logger.Info("Stopping Yoctopuce pressure measure.");
            YoctupuceCapability.Release();
        }

        public Option<ExtraValue> ReadValue()
        {
            var value = this.sensor.get_currentValue();
            return Option.Some(new ExtraValue(value));
        }
    }
}
