﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using BoFilTest.Utils;
using Optional;

namespace BoFilTest.Domain.Modules
{
    class EmulatedExtraMeasure : IExtraMeasure
    {
        private const double PERIOD = 20.0;
        private const double HALF_PERIOD = PERIOD * 0.5;

        private SecondTimer Timer { get; }

        public EmulatedExtraMeasure()
        {
            this.Timer = new SecondTimer();
        }

        public void Cleanup()
        {
            // Nothing to do!
        }

        public Option<ExtraValue> ReadValue()
        {
            double value = Math.IEEERemainder(Timer.Get(), PERIOD);
            if (value > HALF_PERIOD)
            {
                value = HALF_PERIOD - value;
            }
            value /= HALF_PERIOD;
            value *= value;
            value *= value;

            return Option.Some(new ExtraValue(value));
        }
    }
}
