﻿using Optional;

namespace BoFilTest.Domain
{
    public class MeasuredValues
    {
        public static MeasuredValues CreateEmpty()
        {
            return new MeasuredValues(Option.None<Gram>(), Option.None<LiterPerHour>(), Option.None<Pressure>(), Option.None<ExtraValue>());
        }

        public MeasuredValues(Option<Gram> weight, Option<LiterPerHour> flow, Option<Pressure> pressure, Option<ExtraValue> extraValue)
        {
            Weight = weight;
            Flow = flow;
            Pressure = pressure;
            ExtraValue = extraValue;
        }

        /// <summary>
        /// Value measured on the scale
        /// </summary>
        public Option<Gram> Weight { get; }

        /// <summary>
        /// Value measured for gas flow throughput
        /// </summary>
        public Option<LiterPerHour> Flow { get; }

        /// <summary>
        /// Value measured on the pressure measurement instrument
        /// </summary>
        public Option<Pressure> Pressure { get; }

        /// <summary>
        /// Value measured on the second A/D converter input, can be configured
        /// </summary>
        public Option<ExtraValue> ExtraValue { get; }
    }
}
