﻿using BoFilTest.Domain.Modules;
using Modbus.Device;
using System;
using System.IO.Ports;
using System.Threading;

namespace BoFilTest.VoegtlinDemo
{

    class Program
    {
        static void Main(string[] args)
        {
            new Program().Run();

        }

        void Run()
        {
            using (var connection = new VoegtlinDeviceModbusRtuConnection("COM8"))
            {
                ReadSomeValues(new VoegtlinDevice(connection.Master, 1));
            }
        }

        private static void ReadSomeValues(VoegtlinDevice master)
        {
            Console.WriteLine("Serial number: " + master.ReadSerialNumber());
            ushort lut = master.ReadLUTIndex();
            Console.WriteLine("Current LUT: {0}", lut);
            master.WriteLUTIndex(3);
            Console.WriteLine("Current LUT: {0}", master.ReadLUTIndex());
            master.WriteLUTIndex(2);
            Console.WriteLine("Current LUT: {0}", master.ReadLUTIndex());



            for (int i = 0; i < 10; ++i)
            {
                Console.WriteLine("{0}: Flow: {1}, Pressure {2}", i, master.ReadFlow(), master.ReadPressure());
                Thread.Sleep(50);
            }
        }
    }
}
