﻿using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace BoFilTest.BalanceDemo
{
    class Program
    {
        private static SerialPort port = new SerialPort("COM5",
          9600, Parity.Even, 7, StopBits.One);

        static void Main(string[] args)
        {
            port.NewLine = "\r\n";
            port.ReadTimeout = 1000;

            // Create the serial port with basic settings
            port.Open();

            port.WriteLine("PWR 1");
            Thread.Sleep(100);
            var powerResponse = port.ReadLine();
            Console.WriteLine("PWR 1: {0}", powerResponse);
            if (powerResponse.StartsWith("PWR A"))
            {
                // Power was actually switched on, we'll get a second line with the serial number
                Console.WriteLine("PWR 1: {0}", port.ReadLine());
            }
            port.DiscardInBuffer();

            for (int i = 0; i < 10; ++i)
            {
                port.WriteLine("SI");
                var answer = port.ReadLine();
                Console.WriteLine("{0}: {1}", i, answer);
                Thread.Sleep(1000);
            }

            port.WriteLine("PWR 0");
            Console.WriteLine("PWR 0: {0}", port.ReadLine());

            port.Close();
        }
    }
}
